using UnityEngine;

public class PlayerController : MonoBehaviour
{
    //public変数でジャンプ力を設定
    public float jumpForce = 5f;
    // Rigidbody2Dコンポーネントを格納する変数
    private Rigidbody2D rb;
    //地面についているかどうかのフラグ変数
    private bool isGrounded = false;
    //GameManagerオブジェクトを使用するPublic変数
    public GameManager gameManager;


    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void Start()
    {
        // Rigidbody2Dコンポーネントを取得
        rb = GetComponent<Rigidbody2D>();
    }

    //地面（タグは"Ground"）に接触したときisGroundedをtrueにする
    private void OnCollisionEnter2D(Collision2D collision)
    {
        if (collision.gameObject.CompareTag("Ground"))
        {
            isGrounded = true;
        }
    }
    //地面から離れたときisGroundedをfalseにする
    private void OnCollisionExit2D(Collision2D collision)
    {
        if (collision.gameObject.CompareTag("Ground"))
        {
            isGrounded = false;
        }
    }
    // Update is called once per frame
    void Update()
    {
        // スペースキーが押され、地面にいるときにジャンプ
        if (Input.GetKeyDown(KeyCode.Space) && isGrounded)
        {
            // Rigidbody2Dに力を加えてジャンプ
            rb.AddForce(new Vector2(0, jumpForce), ForceMode2D.Impulse);
            // isGroundedをfalseにする
            isGrounded = false;
        }
    }

    //障害物（タグは"Obstacle"）に衝突したとき、ゲームオーバーを呼び出す
    private void OnTriggerEnter2D(Collider2D collision)
    {
        if (collision.gameObject.CompareTag("Obstacle"))
        {
            // GameManagerのGameOverメソッドを呼び出す
            gameManager.GameOver();
        }
    }
}
