using UnityEngine;

public class ObstacleSpawner : MonoBehaviour
{
    // インスペクターでアサインするObstacleプレファブ
    public GameObject obstaclePrefab;

    // 次のスポーンまでのタイマー
    private float spawnTimer;

    // 開始時に初期のタイマーを設定
    void Start()
    {
        spawnTimer = Random.Range(1f, 3f);
    }

    // Update is called once per frame
    void Update()
    {
        // タイマーをカウントダウン
        spawnTimer -= Time.deltaTime;

        // タイマーが0以下になったらプレファブを生成
        if (spawnTimer <= 0f)
        {
            Vector2 spawnPosition = new Vector2(10f, -2.2f);
            Instantiate(obstaclePrefab, spawnPosition, Quaternion.identity);

            // 次回のスポーンまでの時間を1～3秒の間で再設定
            spawnTimer = Random.Range(1f, 3f);
        }
    }
}
